/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/OSL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 */

/*
 * Custom code goes here.
 * A template should always ship with an empty custom.js
 */

let prevWidth = null;
(function ($) {
	"use strict";
	var $window = $(window);
	var $document = $(document);
	var $mobile = 992;
	/*----------------------------------------------*/
	/* Loader  */
	/*----------------------------------------------*/
	$(window).on("load", function () {
		$('.page-loader').fadeOut('slow', function () {
			$(this).remove();
		});
	});
	/*----------------------------------------------*/
	/* main category drop dowm  */
	/*----------------------------------------------*/
	$(function () {
		// add Class for simple menu
		$('.menu  > ul > li > div.popover > ul:not(:has(ul))').addClass('simple-menu');
		// add class
		$('.menu  > ul > li ').each(function (indx) {
			if ($(this).find('ul').hasClass('simple-menu')) {
				$(this).addClass('normal-dropdown');
			}
		});
	});
	/*----------------------------------------------*/
	/* menu mobile  */
	/*----------------------------------------------*/
	$('#menu-icon i').on("click", function () {
		$(this).toggleClass('open-menu');
		var openmenu = $(this).hasClass('open-menu');
		if (openmenu) {
			if ($(window).width() < 992) {
				$(this).parents('body').css('overflow', 'hidden');
			}
			$(this).parents('body').find('#mobile_top_menu_wrapper').addClass('box-menu');
		} else {
			$(this).parents('body').css('overflow', 'visible');
			$(this).parents('body').find('#mobile_top_menu_wrapper').removeClass('box-menu');
		}
	});
	$('.menu-close').on("click", function () {
		$(this).parents('body').css('overflow', 'visible');
		$(this).parents('body').find('#mobile_top_menu_wrapper').removeClass('box-menu');
		$(this).parents('body').find('#menu-icon i').removeClass('open-menu');
	});
	$('.filter-close').on("click", function () {
		$(this).parents('body').find('#search_filters_wrapper').removeClass('filter-open');
		$(this).parents('body').find('#search_filters_wrapper').addClass('hidden-md-down');
		$(this).parents('body').css('overflow', 'visible');
	});
	/*----------------------------------------------*/
	/* header fixed  */
	/*----------------------------------------------*/
	$window.on("scroll", function () {
		if ($window.width() >= parseInt(992, 10)) {
			if ($('body#index').length) {
				if ($window.scrollTop() >= parseInt(45, 10)) {
					$("#header").addClass("header-fixed");
				} else {
					$("#header").removeClass("header-fixed");
				}
				prevWidth = $(window).width();
			}
		}
	});
	$(function () {
		changeHTML();
	});
	$window.on('resize', function () {
		changeHTML();
	});

	function changeHTML() {
		if ($window.width() < parseInt($mobile, 10)) {
			if ($("#left-column").next().is('#content-wrapper')) {
				var elm = $("#content-wrapper");
				elm.insertBefore(elm.prev());
			}
		} else {
			if ($("#content-wrapper").next().is('#left-column')) {
				var elm = $("#left-column");
				elm.insertBefore(elm.prev());
			}
		}
	}
	/*----------------------------------------------*/
	// Update column+content in responsive 
	/*----------------------------------------------*/
	var responsiveflag = !1;
	$(document).ready(function () {
		responsiveResize();
		$(window).resize(responsiveResize);
	});

	function responsiveResize() {
		if ($(window).width() <= 991 && responsiveflag == !1) {
			updateColumnsAndContent('enable');
			responsiveflag = !0;
		} else if ($(window).width() >= 992) {
			updateColumnsAndContent('disable');
			responsiveflag = !1;
		}
	}

	function updateColumnsAndContent(status) {
		if (status == 'enable') {
			$("#left-column .products-section-title, #right-column .products-section-title, .block-blog h4").on('click', function (e) {
				$(this).toggleClass('active').next().stop().slideToggle('medium');
				e.preventDefault();
			});
			$("#left-column .products-section-title, #right-column .products-section-title, .block-blog h4").next().slideUp('fast');
		} else {
			$('#left-column .products-section-title, #right-column .products-section-title, .block-blog h4').removeClass('active').off().next().removeAttr('style').slideDown('fast');
		}
	}
	/*----------------------------------------------*/
	/* drop dowm  */
	/*----------------------------------------------*/
	$(function () {
		$(".header-cart").on('click', function () {
			$(".cart_block").slideToggle("slow");
		});
		$(".currency-selector").on('click', function () {
			$(".cart_block").slideUp("slow");
		});
		$(".language-selector").on('click', function () {
			$(".cart_block").slideUp("slow");
		});
		$("#_desktop_user_info").on('click', function () {
			$(".cart_block").slideUp("slow");
		});
	});
	$(document).on('click', function () {
		$(".cart_block").slideUp('slow');
	});
	/*----------------------------------------------*/
	/* Change Display Type category  */
	/*----------------------------------------------*/
	$(document).on('click', '.pro_list_gird .grid-view', function (e) {
		e.preventDefault();
		$('#categories-product .product-miniature').removeClass('product-list col-xl-12 col-lg-12 col-md-12 col-sm-12').addClass('product-grid col-xl-3 col-lg-4 col-md-4 col-sm-6');
		$('.pro_list_gird').find('.grid-view').addClass('active');
		$('.pro_list_gird').find('.list-view').removeClass('active');
		$('#categories-product .products .product-miniature').each(function (index, element) {
			$('.product-image-wraper', element).removeClass('col-xl-3 col-lg-4 col-md-4 col-sm-5 col-xs-6');
			$('.product-description', element).removeClass('col-xl-9 col-lg-8 col-md-8 col-sm-7 col-xs-6');
		});
		$.cookie('nov_grid_list', 'grid', {
			expires: 1,
			path: '/'
		});
	});
	$(document).on('click', '.pro_list_gird .list-view', function (e) {
		e.preventDefault();
		$('#categories-product .product-miniature').removeClass('product-grid col-xl-3 col-lg-4 col-md-4 col-sm-6').addClass('product-list col-xl-12 col-lg-12 col-md-12 col-sm-12');
		$('.pro_list_gird').find('.grid-view').removeClass('active');
		$('.pro_list_gird').find('.list-view').addClass('active');
		$('#categories-product .products .product-miniature').each(function (index, element) {
			$('.product-image-wraper', element).addClass('col-xl-3 col-lg-4 col-md-4 col-sm-5 col-xs-6');
			$('.product-description', element).addClass('col-xl-9 col-lg-8 col-md-8 col-sm-7 col-xs-6');
		});
		$.cookie('nov_grid_list', 'list', {
			expires: 1,
			path: '/'
		});
	});
	/*----------------------------------------------*/
	/* Owl Slider  */
	/*----------------------------------------------*/
	$(function () {
		//Intro slider
		$('.mthomeslider').owlCarousel({
			autoplay: true,
			autoplayTimeout: $('.mthomeslider').data('interval'),
			autoplayHoverPause: $('.mthomeslider').data('pause'),
			singleItem: true,
			nav: true,
			dots: false,
			items: 1,
			loop: true,
			autoHeight: true,
			animateIn: 'fadeIn',
			animateOut: 'fadeOut',
			navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
			responsive: {
				0: {
					nav: false,
					dots: true
				},
				992: {
					nav: true,
					dots: false
				}
			},
			rtl: jQuery("body").hasClass("lang-rtl") ? true : false
		});
		$('.product-carousel').each(function () {
			if ($(this).closest('#left-column').length == 0 && $(this).closest('#right-column').length == 0) {
				$(this).addClass('owl-carousel owl-theme');
				const items = $(this).data('items') || 5;
				const sliderOptions = {
					loop: false,
					autoplay: false,
					autoplayHoverPause: true,
					singleItem: true,
					dots: false,
					nav: true,
					navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
					items: items,
					responsive: {
						0: {
							items: 1
						},
						320: {
							items: items - 3 > 1 ? items - 3 : 1
						},
						768: {
							items: items - 2 > 1 ? items - 2 : 1
						},
						992: {
							items: items - 1 > 1 ? items - 1 : 1
						},
						1200: {
							items: items
						}
					}
				};
				if (jQuery("body").hasClass("lang-rtl")) sliderOptions['rtl'] = true;
				$(this).owlCarousel(sliderOptions);
			}
		});
		$('.special-carousel').each(function () {
			$(this).addClass('owl-carousel owl-theme');
			const items = $(this).data('items') || 3;
			const sliderOptions = {
				loop: false,
				autoplay: false,
				autoplayHoverPause: true,
				singleItem: true,
				dots: false,
				nav: true,
				navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
				items: items,
				responsive: {
					0: {
						items: 1
					},
					320: {
						items: items - 2 > 1 ? items - 2 : 1
					},
					576: {
						items: items - 1 > 1 ? items - 1 : 1
					},
					1200: {
						items: items
					}
				}
			};
			if (jQuery("body").hasClass("lang-rtl")) sliderOptions['rtl'] = true;
			$(this).owlCarousel(sliderOptions);
		});
		//blog Item 3
		$('.blog-item-3').owlCarousel({
			items: 3,
			loop: false,
			autoplay: false,
			autoplayHoverPause: true,
			singleItem: true,
			dots: false,
			nav: true,
			navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
			responsive: {
				0: {
					items: 1
				},
				320: {
					items: 1
				},
				576: {
					items: 2
				},
				1200: {
					items: 3
				}
			},
			rtl: jQuery("body").hasClass("lang-rtl") ? true : false
		});
		//brand
		$('.brand-items').owlCarousel({
			items: 6,
			loop: false,
			margin: 5,
			autoplay: true,
			autoplayHoverPause: true,
			singleItem: true,
			dots: false,
			nav: true,
			navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
			responsive: {
				0: {
					items: 1
				},
				320: {
					items: 2
				},
				481: {
					items: 3
				},
				992: {
					items: 4
				},
				1200: {
					items: 6
				}
			},
			rtl: jQuery("body").hasClass("lang-rtl") ? true : false
		});
		productPageInit();
	});

	function productPageInit() {
		//product zoom
		$('#product .product-zoom').zoom();
		// additional silder
		setTimeout(function () {
			$('.product-detail .mask.scroll .product-images').owlCarousel({
				items: 5, //1 items above 1000px browser width
				nav: true,
				dots: false,
				loop: false,
				autoplay: true,
				navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
				responsive: {
					0: {
						items: 1
					},
					320: {
						items: 1
					},
					321: {
						items: 2
					},
					375: {
						items: 3
					},
					480: {
						items: 4
					},
					576: {
						items: 5
					},
					768: {
						items: 3
					},
					992: {
						items: 4
					},
					1200: {
						items: 5
					}
				},
				rtl: jQuery("body").hasClass("lang-rtl") ? true : false
			});
		}, 0);
	}
	prestashop.on('updatedProduct', function () {
		productPageInit();
	});
	/*----------------------------------------------*/
	/* quantity seter*/
	/*----------------------------------------------*/
	$(document).on('click', '.plus, .minus', function (e) {
		e.preventDefault();
		var parent = $(this).parents('.product-btn-quantity');
		var quantity = parent.find('[name="quantity"]');
		var val = quantity.val();
		if ($(this).hasClass('plus')) {
			val = parseInt(val) + 1;
		} else {
			if (val == 1) {
				val = 1;
			} else {
				val = val >= 1 ? parseInt(val) - 1 : 0;
			}
		}
		quantity.val(val);
		quantity.trigger("change");
		return false;
	});
	/*----------------------------------------------*/
	/* ajax search */
	/*----------------------------------------------*/
	var timer;
	$("#input_search").keyup(function (e) {
		e.stopPropagation();
		clearTimeout(timer);
		timer = setTimeout(function () {
			var search_key = $("#input_search").val();
			$.ajax({
				type: 'GET',
				url: prestashop['urls']['base_url'] + 'modules/mt_search/mt_search-ajax.php',
				headers: {
					"cache-control": "no-cache"
				},
				async: true,
				data: 'search_key=' + search_key,
				success: function success(data) {
					$('#search_popup').innerHTML = data;
				}
			}).done(function (msg) {
				$("#search_popup").html(msg);
			});
		}, 1000);
	});
	/*----------------------------------------------*/
	/* Newsletter */
	/*----------------------------------------------*/
	$(function () {
		if ($('.newsletter-popup-wrapper').length > 0) {
			//get popup cookie        
			if ($.cookie("newsletterpopup") != 'true') {
				$.magnificPopup.open({
					items: {
						src: '.newsletter-popup-wrapper',
						type: 'inline'
					},
					removalDelay: 500, //delay removal by X to allow out-animation
					callbacks: {
						beforeOpen: function () {},
						open: function () {}
					}
				});
			}
		}
	});
	$(function () {
		// Back to top
		backToTop();
		setPageTitle();
		hoverzoom();
		productzoom();
	});
	$window.on('resize', function () {
		hoverzoom();
		productzoom();
	});
	/*----------------------------------------------*/
	/* More category */
	/*----------------------------------------------*/
	$(document).ready(function () {
		let moreText = $('#_desktop_top_menu').data('more')
		if (!moreText) {
			'More'
		}
		if ($window.width() >= parseInt($mobile, 10)) {
			var max_elem = 4;
			if ($(window).width() < 1200) {
				max_elem = 3;
			}
			var items = $('#top-menu > li:not(.link)');
			var surplus = items.slice(max_elem, items.length);
			surplus.wrapAll('<li class="more_menu"><div class="popover sub-menu js-sub-menu">');
			$('.more_menu').prepend('<a href="#" id="more_asse" class="dropdown-item" data-depth="0">' + moreText + '</a>');
		} else {
			$("#top-menu > li:not(.link)").removeClass(".more_menu");
		}
	});
	/*----------------------------------------------*/
	/* responsive zoom*/
	/*----------------------------------------------*/
	function productzoom() {
		if ($(window).width() >= 992) {
			$('#product .product-zoom').zoom();
		} else {
			$('#product .product-zoom').trigger('zoom.destroy');
		}
	}
	/*----------------------------------------------*/
	/* product comments */
	/*----------------------------------------------*/
	$(document).ready(function () {
		$("#product_comments_block_extra ul.comments_advices a").on('click', function () {
			$('*[class^="tab-pane"]').removeClass('active');
			$('*[class^="tab-pane"]').removeClass('in');
			$('div#tab-review').addClass('active');
			$('div#tab-review').addClass('in');
			$('ul.nav-tabs a[href^="#"]').removeClass('active');
			$('a[href="#tab-review"]').addClass('active');
		});
	});
	$(window).on("load", function () {
		/* Page Scroll to id fn call */
		$("#product_comments_block_extra ul.comments_advices a.reviews ").mPageScroll2id({
			highlightSelector: "#product_comments_block_extra ul.comments_advices a.reviews ",
			offset: 100
		});
	});
	/*----------------------------------------------*/
	/* PageTitle */
	/*----------------------------------------------*/
	function setPageTitle() {
		const heading = document.title;
		$('.breadcrumb h6, #content h1.page_title').html(heading);
	}
	/*----------------------------------------------*/
	// / parallax /
	/*----------------------------------------------*/
	$(function () {
		if ($(window).width() > 767) {
			var parallax = document.querySelectorAll(".parallax"),
			    speed = 0.5;
			window.onscroll = function () {
				[].slice.call(parallax).forEach(function (el, i) {
					var windowYOffset = window.pageYOffset,
					    elBackgrounPos = "50% " + windowYOffset * speed + "px";
					el.style.backgroundPosition = elBackgrounPos;
				});
			};
		}
	});
	/*----------------------------------------------*/
	/* Hover zoom button */
	/*----------------------------------------------*/
	function hoverzoom() {
		setTimeout(function () {
			if ($(window).width() > 767) {
				$('.hover-zoom').magnificPopup({
					type: 'image',
					gallery: {
						enabled: true,
						arrowMarkup: '<button title="%title%" type="button" class="mfp-arrow mfp-arrow-%dir%"><i class="fa fa-angle-%dir% fa-4x"></i></button>'
					}
				});
			}
		}, 1000);
	}
	/*----------------------------------------------*/
	/* Back to top function */
	/*----------------------------------------------*/
	function backToTop() {
		//Check to see if the window is top if not then display button
		$(window).scroll(function () {
			if ($(this).scrollTop() > 250) {
				$('.scrollToTop').fadeIn();
			} else {
				$('.scrollToTop').fadeOut();
			}
		});
		//Click event to scroll to top
		$('.scrollToTop').on('click', function () {
			$('html, body').animate({
				scrollTop: 0
			}, 800);
			return false;
		});
	}
})(jQuery);