{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2016 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<!DOCTYPE HTML>
<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7"{if isset($language_code) && $language_code} lang="{$language_code|escape:'html':'UTF-8'}"{/if}><![endif]-->
<!--[if IE 7]><html class="no-js lt-ie9 lt-ie8 ie7"{if isset($language_code) && $language_code} lang="{$language_code|escape:'html':'UTF-8'}"{/if}><![endif]-->
<!--[if IE 8]><html class="no-js lt-ie9 ie8"{if isset($language_code) && $language_code} lang="{$language_code|escape:'html':'UTF-8'}"{/if}><![endif]-->
<!--[if gt IE 8]> <html class="no-js ie9"{if isset($language_code) && $language_code} lang="{$language_code|escape:'html':'UTF-8'}"{/if}><![endif]-->
<html{if isset($language_code) && $language_code} lang="{$language_code|escape:'html':'UTF-8'}"{/if}>
	<head>
		<meta charset="utf-8" />
		<title>{$meta_title|escape:'html':'UTF-8'}</title>
		{if isset($meta_description) AND $meta_description}
			<meta name="description" content="{$meta_description|escape:'html':'UTF-8'}" />
		{/if}
		{if isset($meta_keywords) AND $meta_keywords}
			<meta name="keywords" content="{$meta_keywords|escape:'html':'UTF-8'}" />
		{/if}
		<meta name="generator" content="PrestaShop" />
		<meta name="robots" content="{if isset($nobots)}no{/if}index,{if isset($nofollow) && $nofollow}no{/if}follow" />
		<meta name="viewport" content="width=device-width, minimum-scale=0.25, maximum-scale=1, initial-scale=1.0" />
		<meta name="apple-mobile-web-app-capable" content="yes" />
		<link rel="icon" type="image/vnd.microsoft.icon" href="{$favicon_url}?{$img_update_time}" />
		<link rel="shortcut icon" type="image/x-icon" href="{$favicon_url}?{$img_update_time}" />		  
        {if isset($css_files)}
			{foreach from=$css_files key=css_uri item=media}
				{if $css_uri == 'lteIE9'}
					<!--[if lte IE 9]>
					{foreach from=$css_files[$css_uri] key=css_uriie9 item=mediaie9}
					<link rel="stylesheet" href="{$css_uriie9|escape:'html':'UTF-8'}" type="text/css" media="{$mediaie9|escape:'html':'UTF-8'}" />
					{/foreach}
					<![endif]-->
				{else}
					<link rel="stylesheet" href="{$css_uri|escape:'html':'UTF-8'}" type="text/css" media="{$media|escape:'html':'UTF-8'}" />
				{/if}
			{/foreach}
		{/if}
		{if isset($js_defer) && !$js_defer && isset($js_files) && isset($js_def)}
			{$js_def}
			{foreach from=$js_files item=js_uri}
			<script type="text/javascript" src="{$js_uri|escape:'html':'UTF-8'}"></script>
			{/foreach}
		{/if}
		{$HOOK_HEADER}        
        
        <!--[if IE 8]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
		<![endif]-->
	</head>    
	<body{if isset($page_name)} id="{$page_name|escape:'html':'UTF-8'}"{/if} class="{if isset($page_name)}{$page_name|escape:'html':'UTF-8'}{/if}{if isset($body_classes) && $body_classes|@count} {implode value=$body_classes separator=' '}{/if}{if $hide_left_column} hide-left-column{else} show-left-column{/if}{if $hide_right_column} hide-right-column{else} show-right-column{/if}{if isset($content_only) && $content_only} content_only{/if} lang_{$lang_iso} {if isset($YBC_TC_CLASSES)}{$YBC_TC_CLASSES}{/if}">
	{if !isset($content_only) || !$content_only}
		{if isset($restricted_country_mode) && $restricted_country_mode}
			<div id="restricted-country">
				<p>{l s='You cannot place a new order from your country.'}{if isset($geolocation_country) && $geolocation_country} <span class="bold">{$geolocation_country|escape:'html':'UTF-8'}</span>{/if}</p>
			</div>
		{/if}
		<div id="page" class="">
		    <div class="header-container">           
                <header id="header" class="{if isset($tc_config.YBC_TC_LAYOUT) && $tc_config.YBC_TC_LAYOUT == 'LAYOUT3' || $tc_config.YBC_TC_LAYOUT == 'LAYOUT4'} header_style_3{else} header_style_2{/if}">
                    {capture name='displayBanner'}{hook h='displayBanner'}{/capture}
                    {if $smarty.capture.displayBanner}
                    	<div class="banner">
                    		<div class="container">
                    			<div class="row">
                    				{$smarty.capture.displayBanner}
                    			</div>
                    		</div>
                    	</div>
                    {/if}
                    {capture name='displayNav'}{hook h='displayNav'}{/capture}
                    
        			<div class="nav">
        				<div class="container">
        					<div class="row">
        						<nav>
                                    {if isset($tc_config.YBC_SHOPMSG_MESSAGE) && $tc_config.YBC_SHOPMSG_MESSAGE != ""}
                                        <div class="shop_alert">
                                            {$tc_config.YBC_SHOPMSG_MESSAGE}
                                        </div>
                                    {/if}
                                    {if $smarty.capture.displayNav}
                                        <div class="toogle_nav_button">
                                            <span class="toogle_nav">
                                                <i class="icon_cog"></i>
                                                {l s='Settings'}
                                            </span>
                                            <div class="toogle_nav_content">
                                                {$smarty.capture.displayNav}
                                            </div>
                                        </div>
                                    {/if}
                                    {if $is_logged}
                                    	<a class="logout userinfor" href="{$link->getPageLink('index', true, NULL, "mylogout")|escape:'html':'UTF-8'}" rel="nofollow" title="{l s='Log me out' mod='blockuserinfo'}">
                                    		<i class="icon_lock_alt"></i>
                                            {l s='Logout'}
                                    	</a>
                                    {else}
                                    	<a class="login userinfor" href="{$link->getPageLink('my-account', true)|escape:'html':'UTF-8'}" rel="nofollow" title="{l s='Log in to your customer account' mod='blockuserinfo'}">
                                    		<i class="icon_lock_alt"></i>
                                            {l s='Login'}
                                    	</a>
                                    {/if}
                                    
                                    {if isset($tc_config.YBC_SHOP_CUSTOMMER_TEXT) && $tc_config.YBC_SHOP_CUSTOMMER_TEXT != ""}
                                        <a class="phone_support userinfor" href="{$tc_config.YBC_SHOP_CUSTOMMER_LINK}">
                                            <i class="icon-headphones"></i>
                                            {$tc_config.YBC_SHOP_CUSTOMMER_TEXT}
                                        </a>
                                    {/if}
                                </nav>
        					</div>
        				</div>
        			</div>
                    <div class="header_bottom{if isset($tc_config.YBC_TC_FLOAT_HEADER) && $tc_config.YBC_TC_FLOAT_HEADER} ybc_float_header{/if}">
            			<div class="container">
                            <div class="d_flex_between">
            					<div id="header_logo" class="">
            						<a href="{if isset($force_ssl) && $force_ssl}{$base_dir_ssl}{else}{$base_dir}{/if}" title="{$shop_name|escape:'html':'UTF-8'}">
            							<img class="logo img-responsive" src="{$logo_url}" alt="{$shop_name|escape:'html':'UTF-8'}"{if isset($logo_image_width) && $logo_image_width} width="{$logo_image_width}"{/if}{if isset($logo_image_height) && $logo_image_height} height="{$logo_image_height}"{/if}/>
            						</a>
            					</div>
                                {if isset($HOOK_TOP)}
                                    {$HOOK_TOP}
                                {/if}
                                
                                {if (isset($tc_config.BLOCKCONTACTINFOS_PHONE) && $tc_config.BLOCKCONTACTINFOS_PHONE)}
                                    <div class="header_contact_phone">
                                        <i class="icon_phone"></i>
                                        <div class="header_contact_phone_text">
                                            <b>{$tc_config.BLOCKCONTACTINFOS_PHONE}</b><br />
                                            {if isset($tc_config.YBC_SHOP_ONLINE_SUPPORT) && $tc_config.YBC_SHOP_ONLINE_SUPPORT != ""}
                                                {$tc_config.YBC_SHOP_ONLINE_SUPPORT}
                                            {else}
                                                {l s='24/7 online support'}
                                            {/if}
                                        </div>
                                    </div>
                                {/if}
                            </div>
            			</div>
                        <div class="main-menu">
                            <div class="container">
                                {hook h='custom'}
                            </div>
                        </div>
            		</div>     
                </header>    
            </div>
        	<div class="columns-container">
                
                    <div id="slider_row" 
                        class="{if isset($tc_config.YBC_TC_LAYOUT) && $tc_config.YBC_TC_LAYOUT == 'LAYOUT2'} container sl_type_2
                        {elseif isset($tc_config.YBC_TC_LAYOUT) && $tc_config.YBC_TC_LAYOUT == 'LAYOUT3'} sl_type_3
                        {elseif isset($tc_config.YBC_TC_LAYOUT) && $tc_config.YBC_TC_LAYOUT == 'LAYOUT4'} container sl_type_1
                        {elseif isset($tc_config.YBC_TC_LAYOUT) && $tc_config.YBC_TC_LAYOUT == 'LAYOUT1'} container sl_type_1{/if}">
                        {capture name='displayTopColumn'}{hook h='displayTopColumn'}{/capture}
            			{if $smarty.capture.displayTopColumn}
            				<div id="top_column" class="">
                                {$smarty.capture.displayTopColumn}
                            </div>
            			{/if}
            		</div>
                
                
                
                {if $page_name !='index' && $page_name !='pagenotfound'}
                    <div class="ybc_full_bg_breadcrum">
                        <div class="container">
            					{include file="$tpl_dir./breadcrumb.tpl"}
                        </div>
                    </div>
                {/if}
        		<div id="columns" class="{if $page_name != 'index'}container{/if}">
        			<div {if $page_name != 'index'}class="row"{/if}>
        				{if isset($left_column_size) && !empty($left_column_size)}
        				<div id="left_column" class="column col-xs-12 col-sm-{$left_column_size|intval}">{$HOOK_LEFT_COLUMN}</div>
        				{/if}
        				{if isset($left_column_size) && isset($right_column_size)}{assign var='cols' value=(12 - $left_column_size - $right_column_size)}{else}{assign var='cols' value=12}{/if}
        				<div id="center_column" class="center_column col-xs-12 col-sm-{$cols|intval}">
{/if}